/*********************************************/
/* Example Program for ET-ADuC847 STAMP V1.0 */
/* MCU      : ADuC847(XTAL = 32.768 KHz)     */
/*          : Frequency Bus = 12.582912 MHz  */
/* Compiler : Keil C51 (V7.50)               */
/* Function : Demo PWM Generate Duty 1-2 mS  */
/* Write By : ETT CO.,LTD.(May/2011)         */
/*********************************************/

//P2.5 = PWM Signal = 20.83mS/1.0mS Duty Cycle

/* include  section */
#include <aduc847.h>						// ADUC847 SFR : File
#include <stdio.h>                			// Prototype declarations for I/O functions

/*--------------------------------------------
The main C function.  Program execution Here 
---------------------------------------------*/
void main (void) 
{ 
  PLLCON = 0x00;							// Initial Clock = 12.582912MHz

  /* Initial MCS51 Serial Port */
  /* Used Timer3 Gen. Baudrate */
  // Baud   = T3CON,T3FD
  // 9600   = 0x86,0x12
  // 19200  = 0x85,0x12
  // 38400  = 0x84,0x12
  // 57600  = 0x83,0x2D
  // 115200 = 0x82,0x2D
  // 230400 = 0x81,0x2D
  T3CON = 0x86;								// 9600BPS/12.58MHz(32.768KHz+PLL)
  T3FD  = 0x12;        
  SCON  = 0x50;  							// Serial Port Mode 1 (N,8,1)
  ES    = 0;     							// Disable Serial Interupt            
  TI    = 1;     							// Set TI to send First char of Keil-UART Function

  //Start of Config PWM = Twin 16 Bit PWM
  PWMCON &= ~0x70;							// Reset PWM Mode
  PWMCON |=  0x30;							// Update PWM Mode = Twin 16Bit PWM 

  PWMCON &= ~0x0C;							// Reset PWM Clock Divide
  PWMCON |=  0x04;							// Update PWM Clock = Select Clock/4

  PWMCON &= ~0x03;							// Reset PWM Clock Source 
  PWMCON |=  0x03;							// Update PWM Clock Source = 12.58MHz

  //Fosc PWM = 12.582912MHz/4 = 3.145728MHz
  //Cycle Count PWM = 1 / 3.145728MHz = 317.89nS
  //Period in Twin 16Bit PWM = 65536 x 317.89nS = 20.83mS
  //Config PWM0(P2.5) Duty Cycle
  //1.0mS Duty Cycle = 1.0mS / 317.89nS = 3145.728 Cycle
  PWM0H   =  0x0C;							// 1.0 mS Duty Cycle(3146:0x0C4A Cycle)
  PWM0L   =  0x4A;

  //1.5mS Duty Cycle = 1.5mS / 317.89nS = 4718.592 Cycle
  //PWM0H   =  0x12;		 					// 1.5 mS Duty Cycle(4719:0x126F Cycle)
  //PWM0L   =  0x6F;

  //2.0mS Duty Cycle = 2.0mS / 317.89nS = 6291.456 Cycle
  //PWM0H   =  0x18;							// 2.0 mS Duty Cycle(6291:0x1893 Cycle)
  //PWM0L   =  0x93;

  /* Print Message to RS232 */
  printf("\nET-STAMP ADuC847.....From ETT CO.,LTD");  
  printf("\nDemo PWM Generate 1.0 mS Duty on P2.5");  

  while(1);									// Loop Continue  
}


